﻿// Description: Sample localization file
// Author: kartu
//
// Language: German / Deutsch
//
return {
	// Standard stuff
	Sony: {
		// USB connected
		DO_NOT_DISCONNECT: "Bitte nicht trennen",
		USB_CONNECTED: "USB verbunden",
		DEVICE_LOCKED: "Ger"+String.fromCharCode(132)+"t gesperrt",

		// About, translate either all or none
		ABOUT_PRSP: "PRS+ Script: @@@script@@@\n" +
			"PRS+ Firmware: @@@firmware@@@\n" +
			"Autor: Mikheil Sukhiashvili aka kartu (kartu3@gmail.com) using work of: " + 
			"igorsk, boroda, obelix, pepak, llasram und anderer.\n" +
			"© GNU Lesser General Public License.",
		ABOUT_1: "Copyright ©2006-2008 Sony Corporation",
		ABOUT_2: "Adobe, the Adobe logo, Reader and PDF are either registered trademarks or" + 
			" trademarks of Adobe Systems Incorporated in the United States and/or other countries.",
		ABOUT_3: "MPEG Layer-3 audio coding technology and patents licensed by Fraunhofer IIS and Thomson." + 
			" MPEG-4 AAC audio coding technology licensed by Fraunhofer IIS (www.iis.fraunhofer.de/amm/).",
		ABOUT_4: "Application software designed and implemented by Kinoma (www.kinoma.com). Portions Copyright ©2006,2007 Kinoma, Inc.",
		ABOUT_5: "Bitstream is a registered trademark, and Dutch, Font Fusion, and Swiss are trademarks, of Bitstream, Inc.",
		ABOUT_6: "Portions of this software are Copyright ©2005 The FreeType Project (www.freetype.org). All rights reserved.",
		ABOUT_7: "This software is based in part on the work of the Independent JPEG Group.",
		AUTHORIZED_SONY: "Authorisiert f"+String.fromCharCode(129)+"r den eBook Store.",
		NOT_AUTHORIZED_SONY: "Nicht authorisiert f"+String.fromCharCode(129)+"r den eBook Store.",
		AUTHORIZED_ADOBE: "Dieses Ger"+String.fromCharCode(132)+"t ist authorisiert f"+String.fromCharCode(129)+"r Adobe DRM-gesch"+String.fromCharCode(129)+"tzte Inhalte.",
		NOT_AUTHORIZED_ADOBE: "Dieses Ger"+String.fromCharCode(132)+"t ist nicht authorisiert f"+String.fromCharCode(129)+"r Adobe DRM-gesch"+String.fromCharCode(129)+"tzte Inhalte.",
		SONY_FW_VERSION: "Version",
		DEVICE_ID: "Ger"+String.fromCharCode(132)+"t",
		
		// Mime & card names
		RICH_TEXT_FORMAT: "RTF-Datei",
		ADOBE_PDF: "PDF-Datei",
		EPUB_DOCUMENT: "EPUB-Dokument",
		BBEB_BOOK: "BBeB Buch",
		PLAIN_TEXT: "Textdatei",
		INTERNAL_MEMORY: "Interner Speicher",
		MEMORY_STICK: "Memory Stick",
		SD_CARD: "SD-Karte",
		
		// Main.xml & kbook.so stuff
		INVALID_FORMAT: "Ung"+String.fromCharCode(129)+"ltiges Format!",
		FORMATTING: "Formatiere...",
		LOADING: "Lade...",
		LOW_BATTERY: "Batterie schwach!",
		HR_WARNING: "Willst Du alle Inhalte L"+String.fromCharCode(153)+"SCHEN, auf Werkseinstellungen zur"+String.fromCharCode(129)+"cksetzen und die DRM-Authorisierung zur"+String.fromCharCode(129)+"cksetzen?\n\nJa - Dr"+String.fromCharCode(129)+"cke 5\nNein - Dr"+String.fromCharCode(129)+"cke MEN"+String.fromCharCode(154)+"",
		DEVICE_SHUTDOWN: "Ger"+String.fromCharCode(132)+"t schaltet aus",
		PRESS_MARK_TO_SHUTDOWN: "Dr"+String.fromCharCode(129)+"cke LESEZEICHEN zum Ausschalten",
		THIS_DEVICE: "dieses Ger"+String.fromCharCode(132)+"tes.",
		PRESS_MARK_TO_DELETE: "Dr"+String.fromCharCode(129)+"cke LESEZEICHEN um",
		THIS_BOOK: "dieses Buch zu l"+String.fromCharCode(148)+"schen.",
		FORMAT_INTERNAL_MEMORY: "Formatiere internen Speicher",
		PRESS_MARK_TO_FORMAT: "Dr"+String.fromCharCode(129)+"cke LESEZEICHEN zum formatieren",
		MSG_INTERNAL_MEMORY: "des internen Speichers.",
		RESTORE_DEFAULTS: "Standardeinstellungen wiederherstellen",
		PRESS_MARK_TO_RESTORE: "Dr"+String.fromCharCode(129)+"cke LESEZEICHEN zum wiederherstellen",
		DEFAULT_SETTINGS: "der Standardeinstellungen.",
		UPPER_PAGE: "Seite",
		ONE_OF_ONE: "1 von 1",
		NO_BATTERY: "Batterie leer!",
		FORMATTING_INTERNAL_MEMORY: "Formatiere internen Speicher...",
		SHUTTING_DOWN: "Gerät ausschalten...",
		
		// Root menu
		CONTINUE: "Weiterlesen",
		BOOKS_BY_TITLE: "B"+String.fromCharCode(129)+"cher nach Titel",
		BOOKS_BY_AUTHOR: "B"+String.fromCharCode(129)+"cher nach Autor",
		BOOKS_BY_DATE: "B"+String.fromCharCode(129)+"cher nach Datum",
		COLLECTIONS: "Sammlungen",
		ALL_BOOKMARKS: "Alle Lesezeichen",
		NOW_PLAYING: "Momentan l"+String.fromCharCode(132)+"uft",
		MUSIC: "Musik",
		PICTURES: "Bilder",
		SETTINGS: "Einstellungen",

		// In Settings
		// orientation
		ORIENTATION: "Ausrichtung",
		HORIZONTAL: "Horizontal",
		VERTICAL: "Vertikal",
		// set date
		SET_DATE: "Datum und Uhrzeit",
		YEAR: "Jahr",
		MONTH: "Monat",
		DATE: "Tag", // Day
		HOUR: "Stunde",
		MINUTE: "Minute",
		// slideshow
		SLIDESHOW: "Diashow",
		SS_ON: "Ja",
		SS_OFF: "Nein,
		SS_TURN: "Aktivieren",
		SS_DURATION: "Intervall",
		SECONDS: "Sekunden",
		// auto standby (aka sleep mode)
		AUTOSTANDBY: "Schlaf-Modus",
		AS_ON: "Ja",
		AS_OFF: "Nein",
		AS_TURN: "Aktivieren",
		// about
		ABOUT: ""+String.fromCharCode(154)+"ber",
		// reset to factory settings
		RESET_TO_FACTORY: "Auf Werkseinstellungen zurücksetzen",
		
		// In Advanced Settings
		ADVANCED_SETTINGS: "Erweiterte Einstellungen",
		// screen lock (aka device lock)
		SCREEN_LOCK: "Ger"+String.fromCharCode(132)+"tesperre",
		SL_OFF: "Ja",
		SL_ON: "Nein",
		SL_CODE: "Code eingeben",
		SL_TURN: "Aktivieren",
		// format device
		FORMAT_DEVICE: "Ger"+String.fromCharCode(132)+"t formatieren",
		
		// In Book menu
		BEGIN: "Anfang",
		END: "Ende",
		BOOKMARKS: "Lesezeichen",
		CONTENTS: "Inhaltsverzeichnis",
		HISTORY: "Verlauf",
		INFO: "Informationen",
		UTILITIES: "Werkzeuge",
		
		// In Book Utilities
		REMOVE_ALL_BOOKMARKS: "Alle Lesezeichen löschen",
		CLEAR_HISTORY: "Verlauf löschen",
		DELETE_BOOK: "Buch l"+String.fromCharCode(148)+"schen",
		
		// In Books by Date
		TODAY: "Heute",
		EARLIER_THIS_WEEK: "Diese Woche",
		LAST_WEEK: "Letzte Woche",
		EARLIER_THIS_MONTH: "Diesen Monat",
		LAST_MONTH: "Letzter Monat",
		EARLIER_THIS_QUARTER: "Dieses Quartal",
		LAST_QUARTER: "Letztes Quartal",
		EARLIER_THIS_YEAR: "Dieses Jahr",
		LAST_YEAR: "Letztes Jahr",
		OLDER: ""+String.fromCharCode(142)+"lter",		
		
		PAGE: "Seite",
		PART: "Teil",
		OF: "von",
		NO_BOOK: "Kein Buch",
		NO_SONG: "Kein Lied",

		// Info title strings, comma separated, no spaces after comma
		INFO_TITLES: "Einband,Titel,Autor,Verleger,Kategorie,eBook ID,Dateityp,Datum,Dateigr"+String.fromCharCode(148)+"ße,Speicherort,Dateipfad,Digitale Rechte,G"+String.fromCharCode(129)+"ltigkeitsende",
		
		// Titles and criterions for "Books by Title" and "Books by Folder"
		// title is displayed, "criterion" is used for sorting.
		//
		// NOTE: if localization doesn't need custom Books by sorting, just remove CUSTOM_SORT, TITLE_*, CRITERION_* items
		CUSTOM_SORT: true, 
		TITLE_1: "0-9",
		CRITERION_1: "0123456789",
		TITLE_2: "A B C",
		CRITERION_2: "ABCabc",
		TITLE_3: "D E F",
		CRITERION_3: "DEFdef",
		TITLE_4: "G H I",
		CRITERION_4: "GHIghi",
		TITLE_5: "J K L",
		CRITERION_5: "JKLjkl",
		TITLE_6: "M N O",
		CRITERION_6: "MNOmno",
		TITLE_7: "P Q R S",
		CRITERION_7: "PQRSpqrs",
		TITLE_8: "T U V W",
		CRITERION_8: "TUVWtuvw",
		TITLE_9: "X Y Z",
		CRITERION_9: "XYZxyz",
		TITLE_0: "Sonstige",
		CRITERION_0: "",

		// Utility function, no need to localize
		toDoubleDigit: function (num) {
			if (num < 10) {
				return "0" + num;
			} else {
				return num;
			}
		},
		FUNC_GET_DATE_TIME: function (date) {
			return this.FUNC_GET_DATE(date) + " " + this.FUNC_GET_TIME(date);
		},
		FUNC_GET_DATE: function (date) {
			var day, month, year;
			day = this.toDoubleDigit(date.getDate());
			month = this.toDoubleDigit(date.getMonth() + 1); 
			year = date.getFullYear();
			return month + "/" + day + "/" + year;
		},
		FUNC_GET_TIME: function (date) {
			var hour, minute;
			hour = this.toDoubleDigit(date.getHours());
			minute = this.toDoubleDigit(date.getMinutes());
			return hour + ":" + minute;
		},
                                FUNC_X_PAGES: function (n) {
                                return this.FUNC_X_SOMETHING(n, "Seiten", "1 Seite", "Keine Seite");
                                },
                                FUNC_X_ITEMS: function (n) {
                                return this.FUNC_X_SOMETHING(n, "Menüpunkte", "1 Menüpunkt", "Kein Menüpunkt");
                                },
                                FUNC_X_SETTINGS: function (n) {
                                return this.FUNC_X_SOMETHING(n, "Einstellungen", "1 Einstellung", "Keine Einstellung");
                                },
                                FUNC_X_PICTURES: function (n) {
                                return this.FUNC_X_SOMETHING(n, "Bilder", "1 Bild", "Kein Bild");
                                },
                                FUNC_X_SONGS: function (n) {
                                return this.FUNC_X_SOMETHING(n, "Lieder", "1 Lied", "Kein Lied");
                                },
                                FUNC_X_BOOKMARKS: function (n) {
                                return this.FUNC_X_SOMETHING(n, "Lesezeichen", "1 Lesezeichen", "Kein Lesezeichen");
                                },
                                FUNC_X_COLLECTIONS: function (n) {
                                return this.FUNC_X_SOMETHING(n, "Sammlungen", "1 Sammlung", "Keine Sammlung");
                                },
                                FUNC_X_BOOKS: function (n) {
                                return this.FUNC_X_SOMETHING(n, "Bücher", "1 Buch", "Kein Buch"); 
		},
		FUNC_X_SOMETHING: function (n, many, one, zero) {
			if (n > 1) {
				return n + " " + many;
			} else if (n == 1) {
				return one;
			} else {
				return zero;
			}
		}
	},
	
	// PRS+ stuff
	Core: {
		NODE_PRSP_SETTINGS:  "PRS+ Einstellungen"
	},
	
	CoreLang: {
		TITLE: "Lokalisierung",
		COMMENT: "Benötigt Neustart",
		OPTION_LANG: "Sprache",
	
		OPTION_DATE_FORMAT: "Datums-Format",
		ddMMMYY: "31/Jan/99",
		ddMONTHYY: "31/Januar/99",
		ddMMMYYYY: "31/Jan/1999",
		ddMONTHYYYY: "31/Januar/1999",
		
		OPTION_DATE_SEPARATOR: "Datums-Separator",
		VALUE_SPACE: "Leerzeichen",
		VALUE_NONE: "Keins",
		
		MONTH_SHORT_1: "Jan",
		MONTH_SHORT_2: "Feb",
		MONTH_SHORT_3: "Mar",
		MONTH_SHORT_4: "Apr",
		MONTH_SHORT_5: "Mai",
		MONTH_SHORT_6: "Jun",
		MONTH_SHORT_7: "Jul",
		MONTH_SHORT_8: "Aug",
		MONTH_SHORT_9: "Sep",
		MONTH_SHORT_10: "Okt",
		MONTH_SHORT_11: "Nov",
		MONTH_SHORT_12: "Dez",		

		MONTH_1: "Januar",
		MONTH_2: "Februar",
		MONTH_3: "März",
		MONTH_4: "April",
		MONTH_5: "Mai",
		MONTH_6: "Juni",
		MONTH_7: "Juli",
		MONTH_8: "August",
		MONTH_9: "September",
		MONTH_10: "Oktober",
		MONTH_11: "November",
		MONTH_12: "Dezember"	
	},
	MenuCaptions: {
		TITLE: "Men"+String.fromCharCode(129)+"-"+String.fromCharCode(154)+"berschriften",
		TITLE_COMMENT: "Erm"+String.fromCharCode(148)+"glicht das Setzen des "+String.fromCharCode(154)+"berschriften-Stils",
		OPTION_STYLE: ""+String.fromCharCode(154)+"berschriften-Stil",
		VALUE_SONY_DEFAULT: "Sony Standard",
		VALUE_ALWAYS_SMALL: "Immer klein",
		VALUE_ALWAYS_BIG: "Immer groß"
	},
	
	TextEncoding: {
		TITLE: "Text-Codierung",
		COMMENT: "Betrifft B"+String.fromCharCode(129)+"cher im TXT,RTF-Format, erfordert Neustart",
		OPTION_TITLE: "Codierung",
		DESCRIPTION: "Erm"+String.fromCharCode(148)+"glicht das "+String.fromCharCode(132)+"ndern der Text-Codierung",
		LATIN: "Latin",
		RUSSIAN:  "Russian (win1251)"
	},
	
	KeyBindings: {
		TITLE: "Tasteneinstellungen",
		DESCRIPTION: "Erm"+String.fromCharCode(148)+"glicht das Binden von Aktionen an Tasten",
		
		DEFAULT_VALUE: "Standardwert",
		
		// Contexts
		GLOBAL:  "Global",
		IN_MENU: "Im Men"+String.fromCharCode(129)+"",
		IN_BOOK:  "Beim Lesen eines Buches",
		
		// Button groups
		NUM_BUTTONS: "Numerische Tasten",
		JP_BUTTONS: "Joypad-Tasten",
		OTHER_BUTTONS: "Andere Tasten",
		VOLUME_BUTTONS: "Lautst"+String.fromCharCode(132)+"rke-Tasten",
		
		// Buttons
		BN_SIZE: "Gr"+String.fromCharCode(148)+"ße-Taste",
		BN_BOOKMARK: "Lesezeichen-Taste",
		BN_BL_NEXT: "Unten links 'weiter'",
		BN_BL_PREVIOUS: "Unten links 'zur"+String.fromCharCode(129)+"ck'",
		BN_SB_NEXT: "Seite 'weiter'",
		BN_SB_PREVIOUS:  "Seite 'zur"+String.fromCharCode(129)+"ck'",
		BN_MENU: "Men"+String.fromCharCode(129)+"-Taste",
		BN_JP_LEFT: "Joypad links",
		BN_JP_RIGHT: "Joypad rechts",
		BN_JP_UP: "Joypad hoch",
		BN_JP_DOWN: "Joypad runter",
		BN_JP_CENTER: "Joypad Mitte",
		BN_H_SIZE: "Gr"+String.fromCharCode(148)+"ße-Taste halten",
		BN_H_BOOKMARK: "Lesezeichen-Taste halten",
		BN_H_BL_NEXT: "Unten links 'weiter' halten",
		BN_H_BL_PREVIOUS: "Unten links 'zur"+String.fromCharCode(129)+"ck' halten",
		BN_H_MENU: "Men"+String.fromCharCode(129)+"-Taste halten",
		BN_H_SB_NEXT: "Seite 'weiter' halten",
		BN_H_SB_PREVIOUS: "Seite 'zur"+String.fromCharCode(129)+"ck' halten",
		BN_H_JP_CENTER: "Joypad Mitte halten",
		BN_H_1: "1 halten",
		BN_H_2: "2 halten",
		BN_H_3: "3 halten",
		BN_H_4: "4 halten",
		BN_H_5: "5 halten",
		BN_H_6: "6 halten",
		BN_H_7: "7 halten",
		BN_H_8: "8 halten",
		BN_H_9: "9 halten",
		BN_H_0: "0 halten",
		BN_VOLUME_DOWN: "Lautst"+String.fromCharCode(132)+"rke-",
		BN_H_VOLUME_DOWN: "Lautst"+String.fromCharCode(132)+"rke- halten",
		BN_VOLUME_UP: "Lautst"+String.fromCharCode(132)+"rke+",
		BN_H_VOLUME_UP: "Lautst"+String.fromCharCode(132)+"rke+ halten",
		
		// Actions
		ACTION_SHUTDOWN: "Herunterfahren",
		ACTION_NEXT_PAGE: "N"+String.fromCharCode(132)+"chste Seite",
		ACTION_PREVIOUS_PAGE: "Vorherige Seite",
		ACTION_NEXT_IN_HISTORY: "N"+String.fromCharCode(132)+"chstes im Verlauf",
		ACTION_PREVIOUS_IN_HISTORY: "Verheriges im Verlauf",
		ACTION_PREVIOUS_SONG: "Verheriges Lied",
		ACTION_NEXT_SONG: "N"+String.fromCharCode(132)+"chstes Lied"
	},
	
	Screenshot: {
		TITLE: "Screenshot",
		ACTION_TITLE: "Screenshot erstellen",
		SAVING_TO: "Speichere nach ",
		FAILED_TO_SAVE: "Fehler beim Speichern",
		OPT_SAVETO: "Speichern nach",
		OPT_FEEDBACK: "Speicher-Fortschritt anzeigen",
		MEMORY_STICK: "Memory Stick",
		FEEDBACK_ON: "ein",
		FEEDBACK_OFF: "aus",
		SD_CARD: "SD-Karte",
		INTERNAL_MEMORY: "Interner Speicher"
	},
	
	BrowseFolders: {
		TITLE:  "Verzeichnis durchsuchen",
		OPTION_SORTING_MODE: "Sortier-Modus",
		VALUE_BY_TITLE: "Nach Titel",
		VALUE_BY_AUTHOR_THEN_TITLE: "Nach Autor, dann Titel",
		VALUE_BY_AUTHOR_SWAPPING: "Nach Autor, Vorname/Nachname vertauscht",
		VALUE_BY_FILENAME: "Nach Dateiname",
		OPTION_TITLE_SORTER: "Beim Sortieren titleSorter benutzen",
		ENABLED: "aktiviert",
		DISABLED: "deaktiviert",
		OPTION_IM_ROOT: "Wurzelverzeichnis des internen Speichers",
		OPTION_CARD_SCAN: "SD-Karte/Memory Stick scanen",
		OPTION_MOUNT: "SD-Karte/Memory Stick mounten (experimental)",
		NODE_RESCAN_INTERNAL_MEMORY: "Internen Speicher erneut scannen",
		NODE_COPY_TO_INTERNAL_MEMORY: "In den internen Speicher kopieren",
		NODE_COPY_TO_INTERNAL_MEMORY_COMMENT: "Kopiert Datei in das Wurzelverzeichnis des internen Speichers",
		NODE_COPY_AND_RESCAN: "Kopieren & internen Speicher erneut scannen",
		NODE_COPY_AND_RESCAN_COMMENT: "Kopiert Datei in das Wurzelverzeichnis des internen Speichers und scannt erneut",
		ERROR_TARGET_EXISTS: "Fehler, Zieldatei existiert bereits",
		NODE_AUDIO_AND_PICTURES: "Audio & Bilder",
		NODE_BROWSE_FOLDERS: "Verzeichnis durchsuchen",
		NODE_BROWSE_FOLDERS_COMMENT: "Das Dateisystem durchsuchen",
		NODE_INTERNAL_MEMORY: "Interner Speicher",
		NODE_MEMORY_STICK: "Memory Stick",
		NODE_MEMORY_STICK_MOUNT: "Memory Stick via mount",
		NODE_SD_CARD: "SD-Karte",
		NODE_SD_CARD_MOUNT: "SD-Karte via mount",
		NODE_GAMES_AND_UTILITIES: "Spiele & Werkzeuge"
	},
	
	Clock: {
		OPTION_STYLE: "Zeitanzeige",
		VALUE_24H: "24 Stunden",
		VALUE_12H: "12 Stunden",
		OPTION_MODE: "Zeitansicht",
		VALUE_ALWAYS_SHOWN: "Immer anzeigen",
		VALUE_SHOWN_ONLY_IN_MENU: "Nur im Men"+String.fromCharCode(129)+" anzeigen",
		VALUE_SHOWN_WHEN_READING: "Nur beim Lesen anzeigen",
		VALUE_OFF: "AUS",
		ACTION_TOGGLE_CLOCK: "Uhr umschalten",
		AM: "am",
		PM: "pm"
	},
	
	PageIndex: {
		TITLE: "Seiten-Index",
		INDEX_STYLE_BOOK: "Index-Stil in B"+String.fromCharCode(129)+"chern",
		INDEX_MODE_BOOK: "Index-Modus in B"+String.fromCharCode(129)+"chern",
		INDEX_MODE_MENU: "Index-Modus im Men"+String.fromCharCode(129)+"",
		INDEX_STYLE_MENU: "Index-Stil im Men"+String.fromCharCode(129)+"",
		OF: "von",
		ALWAYS_SHOWN: "Immer anzeigen",
		NEVER_SHOWN: "Nie anzeigen",
		NOT_SHOWN_IF_SINGLE_PAGE: "Nicht bei einzelner Seite anzeigen"
	},
	
	EpubUserStyle: {
		TITLE: "EPUB benutzerdefinierter Stil",
		COMMENT: "Experimentell: Erst sichtbar, wenn die Bücher nach der Änderung wieder neu ge"+String.fromCharCode(148)+"ffnet werden",
		OPTION_EPUB_CSS_FILE: "EPUB css-Datei des Benutzers",
		VALUE_DISABLED: "deaktiviert"
	}
};
